# Instruções de Instalação - Sistema de Gerenciamento de Flags

## 📁 Estrutura de Arquivos

```
deployment_package/
├── public_html/           # Arquivos do Frontend (HTML, CSS, JS)
│   ├── index.html        # Página principal
│   ├── styles.css        # Estilos CSS
│   └── script.js         # JavaScript do frontend
├── backend/              # Servidor Node.js
│   ├── server.js         # Servidor principal
│   ├── package.json      # Dependências Node.js
│   ├── .env             # Configurações do banco de dados
│   ├── config/          # Configurações
│   ├── middleware/      # Middlewares de autenticação
│   └── routes/          # Rotas da API
├── database/            # Scripts do banco de dados
│   └── schema.sql       # Estrutura do banco MySQL
└── INSTALACAO.md        # Este arquivo
```

## 🚀 Instalação no Servidor

### 1. Upload dos Arquivos
- Faça upload de toda a pasta `deployment_package` para seu servidor
- Os arquivos da pasta `public_html/` devem ir para o diretório público do seu servidor web

### 2. Configuração do Banco de Dados MySQL

Execute o script SQL no seu MySQL:
```bash
mysql -u seu_usuario -p < database/schema.sql
```

### 3. Configuração do Backend (Node.js)

**Instalar dependências:**
```bash
cd backend
npm install
```

**Configurar variáveis de ambiente:**
Edite o arquivo `backend/.env` com suas configurações:
```
DB_HOST=localhost
DB_USER=seu_usuario_mysql
DB_PASSWORD=sua_senha_mysql
DB_NAME=flag_management
JWT_SECRET=seu_jwt_secret_aqui
PORT=3000
```

**Iniciar o servidor:**
```bash
node server.js
```

### 4. Configuração do Frontend

Se necessário, edite o arquivo `public_html/script.js` e altere a URL da API:
```javascript
const API_BASE_URL = 'http://seu-servidor.com:3000/api';
```

## 🔐 Usuários Padrão

O sistema vem com usuários pré-configurados:

**Administradores:**
- Usuário: `jose` | Senha: `password123`
- Usuário: `gabrielpriss` | Senha: `password123`

**Líderes:**
- Usuário: `dagoberto` | Senha: `password123`
- Usuário: `karina` | Senha: `password123`

## ⚙️ Configurações Adicionais

### Para Servidor Apache
Adicione ao `.htaccess` na pasta public_html:
```apache
RewriteEngine On
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteRule ^(.*)$ index.html [QSA,L]
```

### Para Servidor Nginx
Adicione à configuração do site:
```nginx
location / {
    try_files $uri $uri/ /index.html;
}

location /api {
    proxy_pass http://localhost:3000;
    proxy_http_version 1.1;
    proxy_set_header Upgrade $http_upgrade;
    proxy_set_header Connection 'upgrade';
    proxy_set_header Host $host;
    proxy_cache_bypass $http_upgrade;
}
```

## 🔧 Solução de Problemas

1. **Erro de conexão com banco:** Verifique as credenciais no arquivo `.env`
2. **Erro de CORS:** Certifique-se que o backend está configurado para aceitar requisições do seu domínio
3. **Erro 404 nas rotas:** Configure o servidor web para redirecionar todas as rotas para index.html

## 📞 Suporte

Se encontrar problemas, verifique:
- Logs do servidor Node.js
- Console do navegador para erros JavaScript
- Logs do servidor web (Apache/Nginx)
- Conexão com o banco de dados MySQL

## ✅ Funcionalidades Incluídas

- ✅ Sistema de autenticação JWT
- ✅ Cadastro e gerenciamento de flags
- ✅ Filtros avançados
- ✅ Edição rápida de status
- ✅ Gerenciamento de colaboradores
- ✅ Gerenciamento de usuários
- ✅ Sistema de auditoria
- ✅ Dashboard com estatísticas
- ✅ Interface responsiva

