-- Criação do banco de dados
CREATE DATABASE IF NOT EXISTS flag_management;
USE flag_management;

-- Drop tables if they exist to ensure a clean slate
DROP TABLE IF EXISTS audit_logs;
DROP TABLE IF EXISTS flags;
DROP TABLE IF EXISTS employees;
DROP TABLE IF EXISTS users;

-- Tabela de Usuários
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(255) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    role ENUM("Admin", "Lider") NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Tabela de Colaboradores
CREATE TABLE IF NOT EXISTS employees (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    employee_function VARCHAR(255), -- Nova coluna para função
    leader_id INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (leader_id) REFERENCES users(id)
);

-- Tabela de Flags
CREATE TABLE IF NOT EXISTS flags (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    employee_id INT,
    leader_id INT,
    category ENUM("Comportamento", "Desempenho", "Processo", "Segurança", "Cliente", "Comunicação", "Outro"), -- Nova coluna para categoria
    occurred_at VARCHAR(255) NOT NULL, -- Nova coluna para data do ocorrido
    gravity ENUM("Amarela", "Laranja", "Vermelha"), -- Nova coluna para gravidade
    impact_area VARCHAR(255), -- Nova coluna para área de impacto
    impact_other TEXT, -- Nova coluna para outro impacto (texto livre)
    status ENUM("Aberta", "Em análise", "Em plano de ação", "Concluída", "Arquivada") DEFAULT "Aberta", -- Status atualizado
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (employee_id) REFERENCES employees(id),
    FOREIGN KEY (leader_id) REFERENCES users(id)
);

-- Tabela de Auditoria (para registrar ações)
CREATE TABLE IF NOT EXISTS audit_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT,
    action VARCHAR(255) NOT NULL,
    details TEXT,
    timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id)
);

-- Inserção de dados iniciais para usuários
INSERT INTO users (username, password, role) VALUES
("jose", "password123", "Admin"),
("gabrielpriss", "password123", "Admin"),
("dagoberto", "password123", "Lider"),
("karina", "password123", "Lider");


